/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_SqiRom.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    USER - Headerfile of Serial Flash Disk on netX if SQI XiP is active

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_SQIROM_H
#define __AP_SQIROM_H

#ifdef __cplusplus
extern "C" {
#endif

  typedef UINT32 (*PFN_SQIROM_LOCK)              (void* pvData);
  typedef void   (*PFN_SQIROM_UNLOCK)            (UINT32 ulLockRet, void* pvData);

  typedef struct RX_SQIROM_INFO_Ttag
  {
    uint32_t ulPageSize;
    uint32_t ulSectorSize;
    uint32_t ulFlashSize;
  } RX_SQIROM_INFO_T;


  RX_FATAL FAR    DrvSqiRomInit                  (const FAR void FAR*                pvCfg,
                                                  UINT                               uNum);

  RX_RESULT FAR   Drv_SqiRomMountFlash           (RX_HANDLE                          hVol);

  RX_RESULT FAR   Drv_SqiRomReadFlash            (UINT64                             ullOffset,
                                                  UINT8 FAR*                         pabBuf,
                                                  UINT32                             ulSize);

  RX_RESULT FAR   Drv_SqiRomWriteFlash           (UINT64                             ullOffset,
                                                  const UINT8 FAR*                   pabBuf,
                                                  UINT32                             ulSize);

  RX_RESULT FAR   Drv_SqiRomEraseFlash           (UINT64                             ullOffset,
                                                  UINT32                             ulSize);

  RX_RESULT FAR   Drv_SqiRomInfoFlash            (RX_SQIROM_INFO_T*                  ptSqiromInfo);

  RX_RESULT FAR   Drv_SqiRomSetLockConfig        (PFN_SQIROM_LOCK                    pfnLock,
                                                  PFN_SQIROM_UNLOCK                  pfnUnlock,
                                                  void*                              pvData);

  /*****************************************************************************/
  /*! Disable lock for write access (FALSE by default to use with xip firmware)*/
  /*****************************************************************************/
  extern BOOLEAN g_fSqiRomLockDisabled;

#ifdef __cplusplus
}
#endif

#endif
